import React, {useMemo} from 'react';

import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';

import * as i18n from 'i18n/trains-HowToBuyTrainsTicketAtBestPrice';

import Advantages, {TAdvantage} from 'components/Advantages/Advantages';
import Text from 'components/Text/Text';
import TrainsDiscountL from 'icons/illustrations/TrainDiscount/TrainDiscountL';
import TrainsDiscount50L from 'icons/illustrations/Trainsdiscount50/Trainsdiscount50L';
import TrainLowPriceL from 'icons/illustrations/TrainLowPrice/TrainLowPriceL';
import TrainsSchoolSaleL from 'icons/illustrations/TrainsSchoolSale/TrainsSchoolSaleL';

interface IHowToBuyTrainsTicketAtBestPriceProps
    extends IWithClassName,
        IWithQaAttributes {}

const HowToBuyTrainsTicketAtBestPrice: React.FC<IHowToBuyTrainsTicketAtBestPriceProps> =
    props => {
        const {className} = props;

        const deviceType = useDeviceType();

        const advantages = useMemo((): TAdvantage[] => {
            const iconWidth = 220;
            const iconHeight = 180;

            return [
                {
                    title: i18n.earlierAndCheaperTitle(),
                    description: i18n.earlierAndCheaperDescription(),
                    iconWidth,
                    iconHeight,
                    IconComponent: TrainsDiscountL,
                },
                {
                    title: i18n.upperPlacesHalfPriceTitle(),
                    description: i18n.upperPlacesHalfPriceDescription(),
                    iconWidth,
                    iconHeight,
                    IconComponent: TrainsDiscount50L,
                },
                {
                    title: i18n.fixPriceTitle(),
                    description: i18n.fixPriceDescription(),
                    iconWidth,
                    iconHeight,
                    IconComponent: TrainLowPriceL,
                },
                {
                    title: i18n.discountForPupilsTitle(),
                    description: i18n.discountForPupilsDescription(),
                    iconWidth,
                    iconHeight,
                    IconComponent: TrainsSchoolSaleL,
                },
            ];
        }, []);

        const title = useMemo(() => {
            return (
                <Text size={deviceType.isDesktop ? 'xxl' : 'xl'}>
                    {insertJSXIntoKey(i18n.title)({
                        end: (
                            <Text size="inherit" weight="fat">
                                {i18n.titleEnd()}
                            </Text>
                        ),
                    })}
                </Text>
            );
        }, [deviceType]);

        return (
            <Advantages
                className={className}
                title={title}
                advantages={advantages}
                {...prepareQaAttributes(props)}
            />
        );
    };

export default HowToBuyTrainsTicketAtBestPrice;
