import React from 'react';

import {EAdFoxBannerPosition, EAdFoxBannerType} from 'types/AdFox';

import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {isE2ETesting} from 'utilities/testUtils/isE2ETesting';

import BannerLine from 'components/BannerLine/BannerLine';
import AdFoxBanner from 'components/AdFoxBanner/AdFoxBanner';

import cx from './MriaBannerLine.scss';

const MriaBannerLine: React.FC = () => {
    const deviceType = useDeviceType();

    if (isE2ETesting()) {
        return null;
    }

    return (
        <BannerLine
            position="bottom"
            className={cx('wrapper', deviceMods('wrapper', deviceType))}
        >
            <AdFoxBanner
                className={cx('banner')}
                type={EAdFoxBannerType.BottomLine}
                position={EAdFoxBannerPosition.Bottom}
            />
        </BannerLine>
    );
};

export default MriaBannerLine;
