import React from 'react';

import {EAdFoxBannerPosition, EAdFoxBannerType} from 'types/AdFox';

import {deviceMods} from 'utilities/stylesUtils';
import {useBoolean} from 'utilities/hooks/useBoolean';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {isE2ETesting} from 'utilities/testUtils/isE2ETesting';

import BannerPopup from 'components/BannerPopup/BannerPopup';
import AdFoxBanner from 'components/AdFoxBanner/AdFoxBanner';

import cx from './MriaPopup.scss';

const MriaPopup: React.FC = () => {
    const deviceType = useDeviceType();
    const {value, setTrue} = useBoolean(false);

    if (isE2ETesting()) {
        return null;
    }

    return (
        <BannerPopup
            className={cx('wrapper', deviceMods('wrapper', deviceType), {
                wrapper_readyToShow: value,
            })}
        >
            <AdFoxBanner
                className={cx('banner')}
                type={EAdFoxBannerType.Popup}
                position={EAdFoxBannerPosition.Bottom}
                onRender={setTrue}
            />
        </BannerPopup>
    );
};

export default MriaPopup;
