import {IAviaSearchFormValues} from 'projects/avia/components/SearchForm/types';
import IPersonalizedAviaItem from 'server/api/PersonalizationApi/types/IPersonalizedAviaItem';
import {ESearchFormFieldName} from 'components/SearchForm/types';

import {ESuggestSource} from 'components/SearchSuggest/SearchSuggest';

export default function formatSearchHistoryItemsToSearchFormItem(
    searchHistoryItem: IPersonalizedAviaItem,
): IAviaSearchFormValues {
    return {
        [ESearchFormFieldName.START_DATE]: searchHistoryItem.when,
        [ESearchFormFieldName.END_DATE]: searchHistoryItem.returnDate,
        from: {
            inputValue: searchHistoryItem.from.title,
            source: ESuggestSource.PRESETS,
            selectedValue: {
                ...searchHistoryItem.from,
                isUniqueTitle: true,
            },
        },
        to: {
            inputValue: searchHistoryItem.to.title,
            source: ESuggestSource.PRESETS,
            selectedValue: {
                ...searchHistoryItem.to,
                isUniqueTitle: true,
            },
        },
        infants: searchHistoryItem.passengers.infants,
        adults: searchHistoryItem.passengers.adults,
        children: searchHistoryItem.passengers.children,
        isRoundTrip: Boolean(
            searchHistoryItem.when && searchHistoryItem.returnDate,
        ),
        aviaClass: searchHistoryItem.serviceClass,
    };
}
