import React from 'react';
import {Route, Switch} from 'react-router-dom';

import {URLs} from 'constants/urls';

import {ELoadableReducer} from 'types/common/ELoadableReducer';

import contentPageReducer from 'reducers/journal/reducer';

import {loadable} from 'utilities/pageLoadable';

import withReducers from 'containers/withReducers/withReducers';

import RedirectWithStatus from 'components/RedirectWithStatus/RedirectWithStatus';

import Tag from 'projects/journal/pages/Tag/Tag';
import Root from 'projects/journal/pages/Root/Root';
import Article from 'projects/journal/pages/Article/Article';

const NotFoundApp = loadable(
    () => import('components/NotFound/NotFoundPage/NotFoundPage'),
);

const JournalApp: React.FC = () => {
    return (
        <Switch>
            <Route path={URLs.journalRoot} exact component={Root} />
            <Route path={URLs.journalTag} exact component={Tag} />
            <RedirectWithStatus
                from={URLs.journalTags}
                to={`${URLs.journalRoot}/`}
            />
            <Route path={URLs.journalArticle} exact component={Article} />
            <Route component={NotFoundApp} />
        </Switch>
    );
};

export default withReducers([[ELoadableReducer.JOURNAL, contentPageReducer]])(
    JournalApp,
);
