import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {makeAnchor} from 'projects/journal/utilities/makeAnchor';

import Heading, {THeadingLevel} from 'components/Heading/Heading';

import cx from './ArticleBlockTitle.scss';

interface IArticleBlockTitleProps extends IWithClassName {
    title: string;
    anchor?: string;
    level: THeadingLevel;
}

const ArticleBlockTitle: React.FC<IArticleBlockTitleProps> = props => {
    const {className, title, anchor, level} = props;
    const deviceType = useDeviceType();
    const titleNode = (
        <Heading
            className={cx(
                'title',
                `title_level_${level}`,
                !anchor && className,
                deviceMods(`title_level_${level}`, deviceType),
            )}
            level={level}
        >
            {title}
        </Heading>
    );

    return anchor ? (
        /* @ts-ignore */
        <a className={className} name={makeAnchor(anchor)}>
            {titleNode}
        </a>
    ) : (
        titleNode
    );
};

export default ArticleBlockTitle;
