import {Meta} from '@storybook/react/types-6-0';
import routerDecorator from 'storybook/storyDecorators/routerDecorator';

import {ARTICLE_CARD_MOCK} from 'projects/journal/constants/mocks/article';

import {TStorybookFunctionComponent} from 'storybook/types';

import Flex from 'components/Flex/Flex';

import ArticleCard from './ArticleCard';

export default {
    title: 'Journal/ArticleCard',
    component: ArticleCard,
    decorators: [routerDecorator],
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <Flex flexDirection="row" inline between="5" flexWrap="nowrap">
        <ArticleCard {...ARTICLE_CARD_MOCK} />
        <ArticleCard
            {...ARTICLE_CARD_MOCK}
            title="Но иногда требуется чуть больше чем меньше, чтоб стало лучше"
        />
    </Flex>
);
