import React from 'react';
import {Link} from 'react-router-dom';

import {IWithClassName} from 'types/withClassName';
import {IJournalCardProps} from 'projects/journal/types/IJournalCardProps';

import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {useQueryByLocation} from 'utilities/hooks/useQueryByLocation';
import {getArticleUrl} from 'projects/journal/utilities/getArticleUrl';

import Box from 'components/Box/Box';
import Flex from 'components/Flex/Flex';
import Heading from 'components/Heading/Heading';
import TravelImage from 'components/TravelImage/TravelImage';
import CardAuthor from 'projects/journal/components/CardAuthor/CardAuthor';
import TagsOverlay from 'projects/journal/components/TagsOverlay/TagsOverlay';

import cx from './ArticleCard.scss';

const ArticleCard: React.FC<IJournalCardProps & IWithClassName> = props => {
    const {
        className,
        semanticId,
        imageSrc,
        imageAlt,
        title,
        tags,
        author,
        publishDate,
    } = props;
    const query = useQueryByLocation();
    const deviceType = useDeviceType();

    return (
        <div className={cx('root', deviceMods('root', deviceType), className)}>
            <Box className={cx('head')} below={deviceType.isMobile ? 4 : 5}>
                <TravelImage
                    className={cx('image')}
                    src={imageSrc}
                    imageAlt={imageAlt}
                    hasFitCover
                />

                {tags && <TagsOverlay className={cx('tags')} tags={tags} />}
            </Box>

            <Flex flexDirection="column" between={deviceType.isMobile ? 2 : 3}>
                <Heading level="3" className={cx('title')}>
                    {title}
                </Heading>

                <CardAuthor author={author} date={publishDate} />
            </Flex>

            <Link
                className={cx('link')}
                to={getArticleUrl(semanticId, query)}
            />
        </div>
    );
};

export default ArticleCard;
