import React, {useCallback, useMemo} from 'react';
import {useSelector} from 'react-redux';

import {URLs} from 'constants/urls';
import {
    BreadcrumbsList,
    BreadcrumbsListItem,
} from 'constants/schemaOrg/breadcrumbs';

import {IWithClassName} from 'types/withClassName';
import {EJournalGoals} from 'utilities/metrika/types/goals/journal';

import nonceSelector from 'selectors/common/nonceSelector';

import {internalUrl} from 'utilities/url';
import {reachGoal} from 'utilities/metrika';
import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import * as i18nBlock from 'i18n/journal';

import SchemaMarkup, {
    getMetaBreadcrumbList,
} from 'components/SchemaMarkup/SchemaMarkup';

import BreadcrumbsLink from '../BreadcrumbsLink/BreadcrumbsLink';

import cx from './Breadcrumbs.scss';

interface IBreadcrumbsProps extends IWithClassName {}

const Breadcrumbs: React.FC<IBreadcrumbsProps> = props => {
    const {className} = props;
    const deviceType = useDeviceType();
    const nonce = useSelector(nonceSelector);

    // TODO: когда станет понятна иерархия крошек - унести в селектор
    const links = useMemo(
        () => [
            {
                url: internalUrl(URLs.journalRoot, null, {trailingSlash: true}),
                name: i18nBlock.journal(),
            },
        ],
        [],
    );
    const breadcrumbs = useMemo(
        () =>
            getMetaBreadcrumbList(
                links.map(({name, url}) => ({
                    name,
                    url: internalUrl(url, null, {withOrigin: true}),
                })),
            ),
        [links],
    );

    const onClick = useCallback(() => {
        reachGoal(EJournalGoals.JOURNAL_ARTICLE_BREADCRUMBS_CLICK);
    }, []);

    return (
        <>
            {nonce && <SchemaMarkup data={breadcrumbs} nonce={nonce} />}

            <ol className={cx('root', className)} {...BreadcrumbsList}>
                {links.map((item, index) => (
                    <li
                        className={cx(
                            'breadcrumb',
                            deviceMods('breadcrumb', deviceType),
                        )}
                        key={index}
                        {...BreadcrumbsListItem}
                    >
                        <BreadcrumbsLink
                            to={item.url}
                            theme="light"
                            onClick={onClick}
                            {...BreadcrumbsListItem}
                            itemProp="item"
                        >
                            <span itemProp="name">{item.name}</span>
                            <meta
                                itemProp="position"
                                content={`${index + 1}`}
                            />
                        </BreadcrumbsLink>
                    </li>
                ))}
            </ol>
        </>
    );
};

export default Breadcrumbs;
