import React from 'react';

import {IWithClassName} from 'types/withClassName';

import Link, {IRouterLinkProps} from 'components/Link/Link';

import cx from './BreadcrumbsLink.scss';

interface IBreadcrumbsLinkProps extends IWithClassName, IRouterLinkProps {}

const BreadcrumbsLink: React.FC<IBreadcrumbsLinkProps> = props => {
    const {children, className, ...rest} = props;

    return (
        <Link {...rest} className={cx('root', className)}>
            {children}
        </Link>
    );
};

export default BreadcrumbsLink;
