import {Meta} from '@storybook/react/types-6-0';

import {AVATAR_URL_MOCK} from 'constants/mocks/avatarUrl';

import {TStorybookFunctionComponent} from 'storybook/types';

import CardAuthor from './CardAuthor';

export default {
    title: 'Journal/CardAuthor',
    component: CardAuthor,
} as Meta;

export const WithImage: TStorybookFunctionComponent = () => (
    <CardAuthor
        author={{
            name: 'В.И. Ульянов',
            avatar: AVATAR_URL_MOCK,
        }}
        date="04.01.1923"
    />
);

WithImage.parameters = {
    info: {
        comment: 'Блок автора статьи с автаром',
    },
};
