import React from 'react';

import {IWithClassName} from 'types/withClassName';
import {IContextPageAuthor} from 'server/api/TemplatorApi/types/IGetContextPageResponse';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Text from 'components/Text/Text';
import Flex from 'components/Flex/Flex';
import Avatar from 'components/Avatar/Avatar';

import cx from './CardAuthor.scss';

export interface ICardAuthorProps extends IWithClassName, IWithQaAttributes {
    author: IContextPageAuthor;
    date: string;
}

const CardAuthor: React.FC<ICardAuthorProps> = props => {
    const deviceType = useDeviceType();
    const {
        className,
        date,
        author: {name, avatar},
    } = props;

    return (
        <Flex
            className={cx('root', className)}
            inline
            between={2}
            alignItems="flex-start"
            nowrap
        >
            <Avatar className={cx('avatar')} src={avatar} size="xs" />

            <Flex flexDirection="row">
                <Text
                    className={cx('author', deviceMods('author', deviceType))}
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'authorName',
                    })}
                >
                    {name}
                </Text>
                <span
                    className={cx(
                        'publishDate',
                        deviceMods('publishDate', deviceType),
                    )}
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'publishDate',
                    })}
                >
                    {date}
                </span>
            </Flex>
        </Flex>
    );
};

export default CardAuthor;
