import React from 'react';

import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import Footer from 'components/Footer/Footer';

import ContentPageHeader from '../ContentPageHeader/ContentPageHeader';

import cx from './CommonLayout.scss';

interface ICommonLayoutProps {
    color?: string;
}

const CommonLayout: React.FC<ICommonLayoutProps> = props => {
    const {children, color} = props;
    const deviceType = useDeviceType();

    return (
        <div className={cx('root', deviceMods('root', deviceType))}>
            {color && (
                <div
                    className={cx('background')}
                    style={{
                        background: `radial-gradient(at top left, ${color} 0%, rgba(255, 255, 255, 0) ${
                            deviceType.isDesktop ? '67%' : '73%'
                        });`,
                    }}
                />
            )}

            <div className={cx('upLevel')}>
                <ContentPageHeader />
                {children}
            </div>

            <Footer
                className={cx('footer')}
                {...prepareQaAttributes('portalFooter')}
            />
        </div>
    );
};

export default CommonLayout;
