import React, {useCallback} from 'react';
import {useDispatch, useSelector} from 'react-redux';

import {EUserAvatarSize} from 'components/User/types';

import * as mailActions from 'reducers/common/userUnreadMailCount/actions';

import {getUserUndeadMailCount} from 'selectors/common/getUserUndeadMailCount';

import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {useUserInfo} from 'utilities/hooks/useUserInfo';

import User from 'components/User/User';
import YandexTravelLogo from 'components/YandexTravelLogo/YandexTravelLogo';

import cx from './ContentPageHeader.scss';

const ContentPageHeader: React.FC = () => {
    const dispatch = useDispatch();
    const userInfo = useUserInfo();
    const deviceType = useDeviceType();
    const unreadMailCount = useSelector(getUserUndeadMailCount);
    const fetchUserUnreadMailCount = useCallback(() => {
        dispatch(mailActions.fetchUserUnreadMailCount());
    }, [dispatch]);

    return (
        <header className={cx('root', deviceMods('root', deviceType))}>
            <YandexTravelLogo
                className={cx('logo')}
                withYandexLogo
                isSmall={deviceType.isMobile}
            />

            <User
                className={cx('user')}
                userInfo={userInfo}
                avatarSize={
                    deviceType.isMobile ? EUserAvatarSize.S : EUserAvatarSize.L
                }
                unreadMailCount={unreadMailCount}
                fetchUserUnreadMailCount={fetchUserUnreadMailCount}
            />
        </header>
    );
};

export default ContentPageHeader;
