import {Meta} from '@storybook/react/types-6-0';
import routerDecorator from 'storybook/storyDecorators/routerDecorator';

import {ARTICLE_CARD_MOCK} from 'projects/journal/constants/mocks/article';

import {TStorybookFunctionComponent} from 'storybook/types';

import HeaderCard from './HeaderCard';

export default {
    title: 'Journal/HeaderCard',
    component: HeaderCard,
    decorators: [routerDecorator],
} as Meta;

export const Main: TStorybookFunctionComponent = () => (
    <HeaderCard {...ARTICLE_CARD_MOCK} />
);

Main.parameters = {
    info: {
        comment: 'Заголовочная карточка со статьёй',
    },
};
