import {Meta} from '@storybook/react/types-6-0';

import {IMAGE_SRC_MOCK} from 'constants/mocks/images';

import {TStorybookFunctionComponent} from 'storybook/types';

import Hero from './Hero';

export default {
    title: 'Journal/Hero',
    component: Hero,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <Hero src={IMAGE_SRC_MOCK} alt="Яндекс такси 10 лет!" height={500}>
        <h1 style={{color: '#fff'}}>ЯНДЕКС ТАКСИ</h1>
    </Hero>
);

Simple.parameters = {
    info: {
        comment: 'Главная картинка с оверлеем',
    },
};
