import React, {useMemo} from 'react';
import {isNumber} from 'lodash';

import {IWithClassName} from 'types/withClassName';

import {IWithQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import Flex from 'components/Flex/Flex';

import cx from './Hero.scss';

interface IHeroProps extends IWithClassName, IWithQaAttributes {
    /** Источник картинки */
    src: string;
    /** Альтернативная подпись к картинке */
    alt: string;
    /** Высота блока */
    height: number | string;
    contentClassName?: string;
}

const Hero: React.FC<IHeroProps> = ({
    src,
    alt,
    height,
    className,
    contentClassName,
    children,
}) => {
    const style = useMemo(
        () => ({
            height: isNumber(height) ? `${height}px` : height,
        }),
        [height],
    );

    return (
        <Flex
            className={cx('root', className)}
            style={style}
            alignItems="flex-end"
        >
            <img className={cx('image')} src={src} alt={alt} />
            <div className={cx('baseSheet')} />
            <div className={cx('content', contentClassName)}>{children}</div>
        </Flex>
    );
};

export default Hero;
