import React from 'react';
import {useLocation} from 'react-router-dom';

import {IContextPageSeo} from 'server/api/TemplatorApi/types/IGetContextPageResponse';

import {getAbsoluteUrl} from 'utilities/url';

import DocumentMeta from 'components/DocumentMeta/DocumentMeta';
import SocialSharingMeta from 'components/SocialSharingMeta/SocialSharingMeta';

interface IJournalPageMeta {
    seo?: IContextPageSeo;
    canonicalUrl: string;
}

const JournalPageMeta: React.FC<IJournalPageMeta> = props => {
    const {seo, canonicalUrl} = props;
    const location = useLocation();

    if (!seo) {
        return null;
    }

    return (
        <>
            <DocumentMeta
                title={seo?.title}
                description={seo?.description}
                canonicalUrl={canonicalUrl}
            />
            <SocialSharingMeta
                url={getAbsoluteUrl(location.pathname)}
                title={seo?.title}
                description={seo?.description}
                image={seo?.image}
            />
        </>
    );
};

export default JournalPageMeta;
