import {FunctionComponent} from 'react';

import TravelLink, {
    ILegoLinkProps,
    IRouterLinkProps,
} from 'components/Link/Link';

import cx from './Link.scss';

type TLinkProps =
    | Omit<ILegoLinkProps, 'theme'>
    | Omit<IRouterLinkProps, 'theme'>;

const Link: FunctionComponent<TLinkProps> = ({className, ...rest}) => {
    return (
        <TravelLink className={cx('root', className)} theme="none" {...rest} />
    );
};

export default Link;
