import React from 'react';
import {Link, generatePath} from 'react-router-dom';

import {URLs} from 'constants/urls';

import {IWithClassName} from 'types/withClassName';

import {internalUrl} from 'utilities/url';
import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {useQueryByLocation} from 'utilities/hooks/useQueryByLocation';

import cx from './Tag.scss';

export type TJournalTagTheme = 'basic' | 'overlay' | 'light';

export interface ITagProps extends IWithClassName {
    size?: 'l' | 's';
    title: string;
    semanticId: string;
    theme?: TJournalTagTheme;
}

const Tag: React.FC<ITagProps> = props => {
    const deviceType = useDeviceType();
    const {className, size = 's', theme = 'basic', semanticId, title} = props;
    const query = useQueryByLocation();
    const tagUrl = internalUrl(
        generatePath(URLs.journalTag, {tagSlug: semanticId}),
        query,
    );

    return (
        <Link
            className={cx(
                className,
                deviceMods('root', deviceType),
                'root',
                `root_size_${size}`,
                `root_theme_${theme}`,
            )}
            to={tagUrl}
        >
            {title}
        </Link>
    );
};

export default Tag;
