import React from 'react';

import {IWithClassName} from 'types/withClassName';

import Flex from 'components/Flex/Flex';
import Tag, {
    ITagProps,
    TJournalTagTheme,
} from 'projects/journal/components/Tag/Tag';

import cx from './Tags.scss';

interface ITagsProps extends IWithClassName {
    tags: ITagProps[];
    theme?: TJournalTagTheme;
    style?: React.CSSProperties;
}

const Tags: React.FC<ITagsProps> = props => {
    const {tags, theme, style, className} = props;

    if (!tags.length) {
        return null;
    }

    return (
        <div className={className} style={style}>
            <Flex className={cx('wrapper')} inline between="1">
                {tags.map(({semanticId, title}) => (
                    <Tag
                        className={cx('tag')}
                        key={semanticId}
                        title={title}
                        semanticId={semanticId}
                        theme={theme}
                    />
                ))}
            </Flex>
        </div>
    );
};

export default Tags;
