import React from 'react';

import {IWithClassName} from 'types/withClassName';
import {IGetContextPageTag} from 'server/api/TemplatorApi/types/IGetContextPageResponse';

import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import * as i18nBlock from 'i18n/journal';

import Heading from 'components/Heading/Heading';

import Tag from '../Tag/Tag';

import cx from './TagsList.scss';

export interface ITagsListProps extends IWithClassName {
    tags: IGetContextPageTag[];
}

const TagsList: React.FC<ITagsListProps> = props => {
    const deviceType = useDeviceType();
    const {tags: tagsInfo, className} = props;

    return (
        <div className={cx('root', deviceMods('root', deviceType), className)}>
            <Heading
                level={2}
                className={cx(
                    'articlesByTagsTitle',
                    deviceMods('articlesByTagsTitle', deviceType),
                )}
            >
                {i18nBlock.articlesByTagsTitle()}
            </Heading>
            <div className={cx('tagsContainer')}>
                {Boolean(tagsInfo.length) &&
                    tagsInfo.map(tag => {
                        return (
                            <Tag
                                key={`${tag.tagId}`}
                                semanticId={tag.semanticId}
                                title={tag.title}
                                size={deviceType.isDesktop ? 'l' : 's'}
                                theme={'light'}
                                className={cx('tagButton')}
                            />
                        );
                    })}
            </div>
        </div>
    );
};

export default TagsList;
