import React, {useMemo} from 'react';

import {IWithClassName} from 'types/withClassName';

import {deviceMods} from 'utilities/stylesUtils';
import {useLayer} from 'utilities/hooks/useLayer';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Flex from 'components/Flex/Flex';
import Tags from 'projects/journal/components/Tags/Tags';
import {ITagProps} from 'projects/journal/components/Tag/Tag';

import cx from './TagsOverlay.scss';

interface ITagsOverlayProps extends IWithClassName {
    tags: ITagProps[];
}

const TagsOverlay: React.FC<ITagsOverlayProps> = props => {
    const deviceType = useDeviceType();
    const layer = useLayer();
    const tagsStyle = useMemo(
        () => ({
            zIndex: layer,
        }),
        [layer],
    );

    return (
        <Flex
            className={cx(
                'root',
                props.className,
                deviceMods('root', deviceType),
            )}
            alignItems="flex-end"
        >
            <Tags
                className={cx('tags')}
                tags={props.tags}
                style={tagsStyle}
                theme="overlay"
            />
        </Flex>
    );
};

export default TagsOverlay;
