import moment from 'moment';
import {FC, useMemo} from 'react';
import {useSelector} from 'react-redux';

import {IGetContextPageArticle} from 'server/api/TemplatorApi/types/IGetContextPageResponse';

import nonceSelector from 'selectors/common/nonceSelector';

import {HUMAN_DATE_RU} from 'utilities/dateUtils/formats';

import SchemaMarkup, {
    getArticleSchemaMarkup,
} from 'components/SchemaMarkup/SchemaMarkup';

interface IArticleMetaProps {
    article: IGetContextPageArticle;
}

const ArticleMeta: FC<IArticleMetaProps> = ({article}) => {
    const nonce = useSelector(nonceSelector);
    const markupData = useMemo(
        () =>
            getArticleSchemaMarkup({
                headline: article.pageTitle,
                datePublished: article.createdDate,
                dateModified: article.dateModified
                    ? moment(article.dateModified).format(HUMAN_DATE_RU)
                    : article.createdDate,
                author: [
                    {
                        name: article.author.name,
                    },
                ],
                // Картинки приходят без указания схемы
                image: [`https:${article.articleImg}`],
            }),
        [article],
    );

    return <SchemaMarkup data={markupData} nonce={nonce} />;
};

export default ArticleMeta;
