import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Link from 'projects/journal/components/Link/Link';

import cx from './CTALink.scss';

interface ICTALinkProps extends IWithClassName {
    text: string;
    url: string;
    onLinkClick?: (
        e: React.MouseEvent<HTMLDivElement, MouseEvent> & {
            target: HTMLAnchorElement;
        },
    ) => void;
}

export const CTALink = React.forwardRef<HTMLElement, ICTALinkProps>(
    (props, ref) => {
        const {className, url, text, onLinkClick} = props;
        const deviceType = useDeviceType();

        return (
            <Link
                className={cx(
                    'root',
                    className,
                    deviceMods('root', deviceType),
                )}
                url={url}
                target="_blank"
                rel="noopener noreferrer"
                onClick={onLinkClick}
            >
                <span ref={ref}>{text}</span>
            </Link>
        );
    },
);

CTALink.displayName = 'CTALink';

export default CTALink;
