import React from 'react';

import {IJournalArticleImg} from 'projects/journal/types/article/IJournalArticleImg';
import {IWithClassName} from 'types/withClassName';

import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Box from 'components/Box/Box';
import Text from 'components/Text/Text';
import TravelImage from 'components/TravelImage/TravelImage';
import ArticleBlockTitle from 'projects/journal/components/ArticleBlockTitle/ArticleBlockTitle';
import ImageCarouselBlock from 'projects/journal/pages/Article/components/ImageCarouselBlock/ImageCarouselBlock';

import cx from './ImageBlock.scss';

interface IImageBlockProps extends IWithClassName {
    title?: string;
    navigationTitle?: string;
    images: IJournalArticleImg[];
}

const ImageBlock = React.forwardRef<HTMLElement, IImageBlockProps>(
    (props, ref) => {
        const {className, images, title, navigationTitle} = props;
        const deviceType = useDeviceType();

        if (images.length > 1) {
            return <ImageCarouselBlock {...props} />;
        }

        return (
            <Box
                className={className}
                between={deviceType.isDesktop ? 5 : 3}
                ref={ref}
            >
                {title && (
                    <ArticleBlockTitle
                        title={title}
                        anchor={navigationTitle}
                        level={3}
                    />
                )}

                <Box between="1">
                    <TravelImage
                        className={cx('image', deviceMods('image', deviceType))}
                        src={images[0].img}
                        imageAlt={images[0].comment}
                        isWide
                        isLoadOnViewportIntersect
                    />
                    <Text size="s" color="secondary">
                        {images[0].comment}
                    </Text>
                </Box>
            </Box>
        );
    },
);

ImageBlock.displayName = 'ImageBlock';

export default ImageBlock;
