import React from 'react';

import {IWithClassName} from 'types/withClassName';

import Text from 'components/Text/Text';

import cx from './ImageCarouselComments.scss';

export enum EImageCarouselCommentsDirection {
    TO_RIGHT = 'to_right',
    TO_LEFT = 'to_left',
}

export interface IImageCarouselCommentsProps extends IWithClassName {
    comment: string;
    prevComment?: string;
    direction: EImageCarouselCommentsDirection;
}

const ImageCarouselComments: React.FC<IImageCarouselCommentsProps> = props => {
    const {comment, prevComment, direction, className} = props;

    return (
        <div className={cx('root', className)}>
            {prevComment && (
                <Text
                    size="s"
                    color="secondary"
                    className={cx(`prevImageCarouselComment_${direction}`)}
                    key={prevComment}
                >
                    {prevComment}
                </Text>
            )}
            <Text
                size="s"
                color="secondary"
                className={cx(`imageCarouselComment_${direction}`)}
                key={comment}
            >
                {comment}
            </Text>
        </div>
    );
};

export default ImageCarouselComments;
