import React, {FunctionComponent, useCallback, useState} from 'react';

import {IImageCarouselProps} from 'components/ImagesCarousel/ImagesCarousel';

import ImageCarouselComments, {
    EImageCarouselCommentsDirection,
} from '../ImageCarouselComments/ImageCarouselComments';

export interface IRenderImageCarouselControllerProps {
    onPrevButtonClick?: () => void;
    onNextButtonClick?: () => void;
    onScrollContent?: (index?: number) => void;
}

interface IImageCarouselControllerProps {
    images: any;
    children: (
        props: IRenderImageCarouselControllerProps,
    ) => React.ReactElement<IImageCarouselProps>;
}

const ImageCarouselController: FunctionComponent<IImageCarouselControllerProps> =
    ({images, children}) => {
        const [imageIndex, setImageIndex] = useState(0);
        const [prevImageIndex, setPrevImageIndex] = useState(-1);

        const onPrevButtonClick = useCallback(() => {
            setPrevImageIndex(imageIndex);
            setImageIndex(imageIndex > 0 ? imageIndex - 1 : imageIndex);
        }, [setImageIndex, imageIndex, setPrevImageIndex]);

        const onNextButtonClick = useCallback(() => {
            setPrevImageIndex(imageIndex);
            setImageIndex(
                imageIndex < images.length - 1 ? imageIndex + 1 : imageIndex,
            );
        }, [setImageIndex, imageIndex, setPrevImageIndex]);

        const onScrollContent = useCallback(
            index => {
                setPrevImageIndex(imageIndex);
                setImageIndex(index);
            },
            [setImageIndex, imageIndex],
        );

        const prevComment =
            prevImageIndex < imageIndex
                ? images[imageIndex - 1]?.comment
                : images[imageIndex + 1]?.comment;
        const comment =
            prevImageIndex > imageIndex
                ? images[imageIndex]?.comment
                : images[imageIndex]?.comment;

        return (
            <>
                {children({
                    onPrevButtonClick,
                    onNextButtonClick,
                    onScrollContent,
                })}
                <ImageCarouselComments
                    comment={comment}
                    prevComment={
                        Boolean(imageIndex - 1) || Boolean(imageIndex + 1)
                            ? prevComment
                            : undefined
                    }
                    direction={
                        prevImageIndex < imageIndex
                            ? EImageCarouselCommentsDirection.TO_RIGHT
                            : EImageCarouselCommentsDirection.TO_LEFT
                    }
                />
            </>
        );
    };

export default ImageCarouselController;
