import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import * as i18nBlock from 'i18n/journal-authors';

import Flex from 'components/Flex/Flex';
import ZenL from 'icons/illustrations/Zen/ZenL';
import Link from 'projects/journal/components/Link/Link';

import cx from './ZenAuthorFooter.scss';

interface IZenAuthorFooterProps extends IWithClassName {
    link: string;
}

const ZenAuthorFooter: FunctionComponent<IZenAuthorFooterProps> = ({
    className,
    link,
}) => {
    const {isDesktop} = useDeviceType();

    return (
        <Flex className={cx('root', className)}>
            <ZenL
                className={cx('icon')}
                width={isDesktop ? 24 : 20}
                height={isDesktop ? 24 : 20}
            />
            <Link url={link} target="_blank" rel="noopener noreferrer">
                {i18nBlock.readMoreOnZen()}
            </Link>
        </Flex>
    );
};

export default ZenAuthorFooter;
