import {useEffect} from 'react';
import {useParams} from 'react-router-dom';
import {useDispatch, useSelector} from 'react-redux';

import {ServerDataFetcherBag} from 'server/redux/types';

import {fetchArticle} from 'reducers/journal/thunk/fetchArticle';

import journalArticlePageSelector from 'selectors/journal/journalArticlePageSelector';

import {useBranch} from 'projects/journal/utilities/useBranch';
import {usePreview} from 'projects/journal/utilities/usePreview';
import useServerDataFetcher from 'utilities/hooks/useServerDataFetcher';

export function useFetchArticle(): void {
    const {articleSlug} = useParams<{articleSlug: string}>();
    const isPreview = usePreview();
    const branch = useBranch();

    // server data fetching
    useServerDataFetcher([
        async ({req, dispatch}: ServerDataFetcherBag): Promise<void> => {
            await dispatch(
                fetchArticle({
                    semanticId: articleSlug,
                    isPreview,
                    branch,
                    req,
                }),
            );
        },
    ]);

    // client data fetching
    const dispatch = useDispatch();
    const article = useSelector(journalArticlePageSelector);

    useEffect(() => {
        if (
            (!article.isFetched && !article.isFetching) ||
            (article.data && article.data?.semanticId !== articleSlug)
        ) {
            dispatch(
                fetchArticle({semanticId: articleSlug, isPreview, branch}),
            );
        }
    }, [dispatch, article, articleSlug, isPreview, branch]);
}
