import {useEffect} from 'react';
import {useDispatch, useSelector} from 'react-redux';

import {ServerDataFetcherBag} from 'server/redux/types';

import {fetchRootPage} from 'reducers/journal/thunk/fetchRootPage';

import journalRootPageSelector from 'selectors/journal/journalRootPageSelector';

import {useBranch} from 'projects/journal/utilities/useBranch';
import {usePreview} from 'projects/journal/utilities/usePreview';
import useServerDataFetcher from 'utilities/hooks/useServerDataFetcher';

export function useFetchRootPage(): void {
    const isPreview = usePreview();
    const branch = useBranch();

    // server data fetching
    useServerDataFetcher([
        async ({req, dispatch}: ServerDataFetcherBag): Promise<void> => {
            await dispatch(
                fetchRootPage({
                    req,
                    branch,
                    isPreview,
                    semanticId: 'journal',
                }),
            );
        },
    ]);

    // client data fetching
    const dispatch = useDispatch();
    const {isFetched, isFetching} = useSelector(journalRootPageSelector);

    useEffect(() => {
        if (!isFetched && !isFetching) {
            dispatch(
                fetchRootPage({
                    branch,
                    isPreview,
                    semanticId: 'journal',
                }),
            );
        }
    }, [dispatch, isFetched, isFetching, isPreview, branch]);
}
