import {useEffect} from 'react';
import {useDispatch, useSelector} from 'react-redux';

import {ServerDataFetcherBag} from 'server/redux/types';

import {fetchTagPage} from 'reducers/journal/thunk/fetchTagPage';

import journalTagPageSelector from 'selectors/journal/journalTagPageSelector';

import {useBranch} from 'projects/journal/utilities/useBranch';
import {usePreview} from 'projects/journal/utilities/usePreview';
import useServerDataFetcher from 'utilities/hooks/useServerDataFetcher';

export function useFetchTagPage(tagSlug: string): void {
    const isPreview = usePreview();
    const branch = useBranch();

    // server data fetching
    useServerDataFetcher([
        async ({req, dispatch}: ServerDataFetcherBag): Promise<void> => {
            await dispatch(
                fetchTagPage({
                    req,
                    tagSlug,
                    branch,
                    isPreview,
                }),
            );
        },
    ]);

    // client data fetching
    const dispatch = useDispatch();
    const {isFetched, isFetching, data} = useSelector(journalTagPageSelector);

    useEffect(() => {
        if (
            (!isFetched && !isFetching) ||
            (data?.meta && data.meta.semanticId !== tagSlug)
        ) {
            dispatch(
                fetchTagPage({
                    tagSlug,
                    branch,
                    isPreview,
                }),
            );
        }
    }, [dispatch, isFetched, isFetching, tagSlug, isPreview, branch, data]);
}
