import {TJournalArticleBlock} from 'projects/journal/types/article/TJournalArticleBlock';
import {EJournalArticleContentBlockType} from 'projects/journal/types/article/EJournalArticleContentBlockType';
import {IJournalArticleImgSet} from 'projects/journal/types/article/IJournalArticleImg';
import {IJournalArticleMarkup} from 'projects/journal/types/article/IJournalArticleMarkup';
import {IJournalArticleMap} from 'projects/journal/types/article/IJournalArticleMap';
import {IJournalArticleCTALink} from 'projects/journal/types/article/IJournalArticleCTALink';

export function isMarkupBlock(
    block: TJournalArticleBlock,
): block is IJournalArticleMarkup {
    return block.blockType === EJournalArticleContentBlockType.TEXT;
}

export function isImageBlock(
    block: TJournalArticleBlock,
): block is IJournalArticleImgSet {
    return block.blockType === EJournalArticleContentBlockType.IMAGE_SET;
}

export function isMapBlock(
    block: TJournalArticleBlock,
): block is IJournalArticleMap {
    return block.blockType === EJournalArticleContentBlockType.MAP;
}

export function isCTALinkBlock(
    block: TJournalArticleBlock,
): block is IJournalArticleCTALink {
    return block.blockType === EJournalArticleContentBlockType.CTA_LINK;
}
