import {INavigationItem} from 'types/common/INavigationItem';
import {TJournalArticleBlock} from 'projects/journal/types/article/TJournalArticleBlock';
import {IJournalArticleMarkup} from 'projects/journal/types/article/IJournalArticleMarkup';

import {makeAnchor} from 'projects/journal/utilities/makeAnchor';

interface INotEmptyContextPageContent
    extends Omit<IJournalArticleMarkup, 'navigationTitle'> {
    navigationTitle: string;
}

const isNotEmptyTitle = (
    block: TJournalArticleBlock,
): block is INotEmptyContextPageContent => {
    return Boolean(block.navigationTitle);
};

export function buildNavigation(
    blocks: TJournalArticleBlock[],
): INavigationItem[] {
    return blocks.filter(isNotEmptyTitle).map(block => ({
        text: block.navigationTitle,
        anchor: makeAnchor(block.navigationTitle),
    }));
}
