import {omit} from 'lodash';
import {generatePath} from 'react-router-dom';

import {URLs} from 'constants/urls';

import {IUrlQuery} from 'utilities/url/types';

import {internalUrl} from 'utilities/url';

const PARAMS_BLACKLIST = [
    'page', // параметр пагинации
];

// Вернёт ссылку на статью с прокинутыми параметрами за исключением служебных
export function getArticleUrl(
    articleSlug: string,
    query?: IUrlQuery | null,
): string {
    return internalUrl(
        generatePath(URLs.journalArticle, {articleSlug}),
        omit(query, PARAMS_BLACKLIST),
    );
}
