import {IGetContextPageTag} from 'server/api/TemplatorApi/types/IGetContextPageResponse';

export function mapTags(
    tagIds: string[],
    tags: IGetContextPageTag[],
): IGetContextPageTag[] {
    const tagMap = tags.reduce<Record<string, IGetContextPageTag>>(
        (acc, item) => ({
            ...acc,
            [item.tagId]: item,
        }),
        {},
    );

    return tagIds.filter(tag => tagMap[tag]).map(tag => tagMap[tag]);
}
