import React from 'react';
import {isString, uniqueId} from 'lodash';

import {TMarkupItem} from 'projects/journal/types/markup';

import {processAttrs} from 'projects/journal/utilities/markup/processAttrs';
import {processTag} from 'projects/journal/utilities/markup/processTag';

export function buildMarkup(item?: TMarkupItem): React.ReactNode {
    if (Array.isArray(item)) {
        return item.map(buildMarkup);
    }

    if (isString(item)) {
        return item;
    }

    if (!item) {
        return null;
    }

    const [Component, attrs] = processTag(item);

    return (
        <Component key={uniqueId()} {...processAttrs(attrs)}>
            {Array.isArray(item.content)
                ? item.content.map(buildMarkup)
                : buildMarkup(item.content)}
        </Component>
    );
}
