import {camelCase, fromPairs} from 'lodash';

export function inlineStylesToObject(styles: string): Record<string, string> {
    return fromPairs(
        styles
            .split(/;\s?/)
            .filter(Boolean)
            .map((item: string) => {
                const [styleKey, ...rest] = item.split(/:\s?/);

                return [camelCase(styleKey.trim()), rest.join(':').trim()];
            }),
    );
}
