import {camelCase} from 'lodash';

import {IMarkupItem} from 'projects/journal/types/markup';

import {inlineStylesToObject} from 'projects/journal/utilities/markup/inlineStylesToObject';

function getAttrName(rawName: string): string {
    switch (rawName) {
        case 'class':
            return 'className';
        case 'rowspan':
            return 'rowSpan';
        case 'colspan':
            return 'colSpan';
        default:
            return camelCase(rawName);
    }
}

export function processAttrs(
    rawAttrs?: IMarkupItem['attrs'],
): Record<string, any> {
    const attrs: Record<string, any> = {};

    if (rawAttrs) {
        Object.entries(rawAttrs).forEach(([key, value]) => {
            switch (key) {
                case 'style':
                    attrs.style = inlineStylesToObject(value);

                    break;
                default:
                    attrs[getAttrName(key)] = value;
            }
        });
    }

    return attrs;
}
