import {ComponentClass, FunctionComponent} from 'react';

import {IMarkupItem} from 'projects/journal/types/markup';

import {processAttrs} from 'projects/journal/utilities/markup/processAttrs';

import Text from 'components/Text/Text';
import Heading from 'components/Heading/Heading';
import Link from 'projects/journal/components/Link/Link';

type THeadingTag = 'h2' | 'h3' | 'h4';
type THeadingLevel = 1 | 2 | 3;

const headingMap: Record<THeadingTag, THeadingLevel> = {
    h2: 1,
    h3: 2,
    h4: 3,
};

export function processTag(
    item: IMarkupItem,
): [
    string | FunctionComponent<any> | ComponentClass<any, any>,
    Record<string, any> | undefined,
] {
    switch (item.tag) {
        case 'h2':
        case 'h3':
        case 'h4':
            return [
                Heading,
                {
                    ...item.attrs,
                    level: headingMap[item.tag],
                },
            ];
        case 'p':
        case 'li':
            return [
                Text,
                {
                    tag: item.tag,
                    tagProps: processAttrs(item.attrs),
                },
            ];
        case 'a':
            return [
                Link,
                {
                    ...item.attrs,
                    url: item.attrs?.href,
                },
            ];
        default:
            return [item.tag, item.attrs];
    }
}
