export const ARTICLE_MOCK = {
    type: 'travel_article',
    semanticId: 'gid_kaliningrad',
    pageTitle: 'Большой гид по Калининграду и области',
    articleImg:
        '//avatars.mds.yandex.net/get-marketcms/1534436/img-5653fb18-99b3-4dce-9f58-65ca1265ea7f.png/optimize',
    author: {
        name: 'Филлип Конеев',
        avatar: '//avatars.mds.yandex.net/get-marketcms/1534436/img-f7716aa8-f46f-41b2-8ea1-e616f2080794.jpeg/optimize',
    },
    createdDate: '07.10.2021',
    tags: [],
    seo: {
        title: 'Большой гид по Каоининграду и области',
        description:
            'Калининград — одно из самых популярных направлений для поездок внутри России. Путешественников влекут суровое море, прекрасная прибалтийская природа и насыщенная история региона: каждая эпоха нашла в городе и окрестностях отражение.',
        image: '//avatars.mds.yandex.net/get-marketcms/1357599/img-260072a0-efd0-4dc8-ac29-452cb2f35e99.png/optimize',
    },
    pageContent: [
        {
            blockType: 'text',
            blockTitle: 'Когда ехать в Калининград',
            content: [
                {
                    tag: 'p',
                    content:
                        'Калининградская область, конечно, — приморский регион, и в Балтике, вопреки слухам, купаются. Но всё же стоит учитывать, что это не Чёрное море и не Индийский океан. Даже в тёплые годы температура воды редко поднимается выше 20 градусов. К тому же балтийская погода знаменита своей непредсказуемостью. Если готовы рискнуть, выбирайте для отпуска вторую половину июля и первую половину августа, когда наверняка удастся выхватить хотя бы несколько жарких дней на пляже.',
                    attrs: {style: 'margin-left:0px;'},
                },
                {
                    tag: 'p',
                    content:
                        'Кроме того, в Калининграде мягкий климат, поэтому холода обычно наступают здесь позже. В городе много деревьев, и весь октябрь можно любоваться золотой осенью и хрустеть опавшей листвой под ногами во время прогулок в парках. На майские в Калининграде обычно довольно тепло, так что поздняя весна — тоже отличное время для поездки.',
                    attrs: {style: 'margin-left:0px;'},
                },
                {
                    tag: 'p',
                    content:
                        'А вот зимой и на новогодние праздники ехать в Калининград, наверное, не лучшая идея. Зима здесь тёплая, но из-за влажного морского воздуха промозглая, к тому же снега почти не бывает, поэтому в декабре и январе в городе обычно мокрая слякоть.',
                    attrs: {style: 'margin-left:0px;'},
                },
            ],
        },
        {
            blockType: 'image_set',
            blockTitle: null,
            imgSet: [
                {
                    img: '//avatars.mds.yandex.net/get-marketcms/1357599/img-59caf892-173d-49da-a514-2ec771a7a4eb.jpeg/optimize',
                    comment: 'Фото: Shutterstock',
                },
                {
                    img: '//avatars.mds.yandex.net/get-marketcms/1357599/img-59caf892-173d-49da-a514-2ec771a7a4eb.jpeg/optimize',
                    comment: 'Фото: Shutterstock',
                },
            ],
        },
        {
            blockType: 'text',
            blockTitle: 'Как добраться',
            content: [
                {tag: 'h4', content: 'Самолётом'},
                {
                    tag: 'p',
                    content:
                        'Калининградская область — это так называемый эксклав, то есть регион не граничит с основной территорией России по суше. Сухопутные границы у региона есть с двумя европейскими государствами: Литвой и Польшей. Поэтому проще всего добраться в Калининград на самолёте — потребуется только внутренний российский паспорт и билет. Больше всего прямых рейсов в Калининград из Москвы, по этому маршруту и обратно летают все основные российские авиакомпании по несколько раз в день. В Калининград также просто добраться из Санкт-Петербурга. Лететь из Москвы и Петербурга примерно полтора часа.',
                    attrs: {style: 'margin-left:0px;'},
                },
                {
                    tag: 'p',
                    content:
                        'Лучше запланировать поездку так, чтобы прилетать и улетать в будний день, тогда билет в одну сторону без багажа обойдётся в 2-4,5 тысяч рублей. Если прилетать вечером пятницы, а улетать вечером воскресенья, цена вырастет до 5–8 тысяч рублей. Цены на билет в одну сторону у «Аэрофлота» стартуют от 6000 ₽ из Москвы и 7000 ₽ из Петербурга, у S7 — от 5600 ₽ из Москвы, у Utair — от 4000 ₽ из Москвы (без багажа), у «Победы» (без багажа) — от 3500 ₽ из Москвы и 4300 ₽ из Петербурга. В летний сезон и на праздники билеты стоят дороже, чем осенью или зимой.',
                    attrs: {style: 'margin-left:0px;'},
                },
                {
                    tag: 'p',
                    content:
                        'Калининград — одно из направлений, для которых действуют так называемые субсидированные билеты за 3300 ₽ в одну сторону. Воспользоваться ими может любой гражданин РФ, но билеты нужно отлавливать на сайтах авиакомпаний.',
                    attrs: {style: 'margin-left:0px;'},
                },
                {tag: 'p', content: ' ', attrs: {style: 'margin-left:0px;'}},
                {
                    tag: 'ul',
                    content: {
                        tag: 'li',
                        content: {
                            tag: 'a',
                            content: 'Недорогие билеты на самолет',
                            attrs: {
                                rel: 'noopener noreferrer',
                                href: 'https://travel.yandex.ru/avia/routes/moscow--kaliningrad/',
                                target: '_blank',
                            },
                        },
                    },
                },
            ],
        },
        {
            blockType: 'image_set',
            blockTitle: null,
            imgSet: [
                {
                    img: '//avatars.mds.yandex.net/get-marketcms/1779479/img-08688b84-7f73-4702-9275-e0caaf35ca66.jpeg/optimize',
                    comment: 'Фото: Shutterstock',
                },
            ],
        },
        {
            blockType: 'text',
            blockTitle: null,
            content: [
                {tag: 'h4', content: 'Поездом'},
                {
                    tag: 'p',
                    content:
                        'Чтобы доехать до Калининграда на поезде, нужно пересечь границы с Белоруссией и Литвой, а значит, потребуется заграничный паспорт. Шенгенскую визу делать не нужно — для проезда делают специальный упрощённый транзитный документ. Поэтому, если нет действующего шенгена, билеты нужно покупать минимум за двое суток до отъезда. Дорога из Москвы (от 4200 ₽ в одну сторону в купе) и Петербурга (от 3600 ₽) занимает около суток, из Смоленска (от 2500 ₽) — 16 часов.',
                },
                {
                    tag: 'ul',
                    content: {
                        tag: 'li',
                        content: {
                            tag: 'a',
                            content: 'Недорогие билеты на поезд',
                            attrs: {
                                rel: 'noopener noreferrer',
                                href: 'https://travel.yandex.ru/trains/',
                                target: '_blank',
                            },
                        },
                    },
                },
                {
                    tag: 'h4',
                    content: 'На автомобиле',
                    attrs: {style: 'margin-left:0px;'},
                },
                {
                    tag: 'p',
                    content:
                        'А вот чтобы доехать до Калининграда на машине, шенгенская виза нужна обязательно. А кроме неё — открытые границы, так что пока, в условиях пандемии, доехать до Калининграда на машине не получится. Когда же ограничения снимут, самый коротким будет путь из Москвы — через Минск и Вильнюс, занимает около 22 часов. Из Петербурга удобнее ездить через Латвию и Литву, время в пути — от 17 часов. Обратите внимание, что на границах Белоруссия — Литва и Литва — Россия могут быть большие пробки, поэтому изучите альтернативные маршруты (например, через Куршскую косу, на которой тоже есть КПП между Россией и Литвой).',
                    attrs: {style: 'margin-left:0px;'},
                },
                {
                    tag: 'h4',
                    content: 'Автобусом',
                    attrs: {style: 'margin-left:0px;'},
                },
                {
                    tag: 'p',
                    content:
                        'Прямого автобусного сообщения Калининграда с «основной» территорией России нет.',
                    attrs: {style: 'margin-left:0px;'},
                },
                {
                    tag: 'h4',
                    content: 'Перевозка транспортных средств на пароме',
                    attrs: {style: 'margin-left:0px;'},
                },
                {
                    tag: 'p',
                    content:
                        'Несколько раз в неделю из Усть-Луга (Ленинградская область) в город Балтийск (45 километров от Калининграда) ходит паром, на котором в регион можно перевезти личное транспортное средство. Перевозка мотоцикла обойдётся в 12 500 ₽, легкового авто без прицепа — в 27 700 ₽. Время в пути составит почти двое суток.',
                    attrs: {style: 'margin-left:0px;'},
                },
                {
                    tag: 'p',
                    content: [
                        'В теории в «нековидные» времена на пароме могут уехать и владельцы ТС, и даже пассажиры без авто (загран и виза не требуются), но в реальности каюты почти всегда заняты дальнобойщиками и военными. Узнать о наличии свободных мест можно только в порту в день отправления, но рассчитывать на них не стоит. Расписание парома (зависит от погодных условий) нужно уточнять на ',
                        {
                            tag: 'a',
                            content: {tag: 'u', content: 'сайте'},
                            attrs: {
                                rel: 'noopener noreferrer',
                                href: 'https://www.eurotek.ru/ferry_schedule',
                                target: '_blank',
                            },
                        },
                        ' перевозчика.',
                    ],
                    attrs: {style: 'margin-left:0px;'},
                },
            ],
        },
        {
            blockType: 'text',
            blockTitle: 'Как доехать из аэропорта',
            content: [
                {
                    tag: 'p',
                    content: {tag: 'strong', content: 'На автобусе'},
                    attrs: {style: 'margin-left:0px !important;'},
                },
                {
                    tag: 'p',
                    content:
                        'Из аэропорта Храброво в Калининград дешевле всего добраться на автобусе, который ходит каждые 40 минут. Время в пути — около 45 минут, стоимость проезда — 100 ₽. Остановка находится прямо на выходе из аэропорта. В другие города области автобусы из аэропорта не ходят.',
                    attrs: {style: 'margin-left:0px !important;'},
                },
                {
                    tag: 'p',
                    content: ' ',
                    attrs: {style: 'margin-left:0px !important;'},
                },
                {
                    tag: 'p',
                    content: {tag: 'strong', content: 'На такси'},
                    attrs: {style: 'margin-left:0px !important;'},
                },
                {
                    tag: 'p',
                    content:
                        'Перемещаться по региону можно на «Яндекс.Такси» и Uber (поездка из Храброво до центра города обойдётся рублей в 500-600). Поездка на местном такси «Максим» будет стоить рублей на 100 дешевле.',
                    attrs: {style: 'margin-left:0px !important;'},
                },
                {
                    tag: 'p',
                    content: ' ',
                    attrs: {style: 'margin-left:0px !important;'},
                },
                {
                    tag: 'p',
                    content: {tag: 'strong', content: 'На автомобиле'},
                    attrs: {style: 'margin-left:0px !important;'},
                },
                {
                    tag: 'p',
                    content:
                        'В Храброво работают сервисы аренды автомобилей: Sixt, Avis, местные компании «Пруссия», «АвтоРентал». В области есть и каршеринг «Сити-Рент», но сервис пока только развивается, машин в парке немного, и нередко попадается механическая коробка передач, так что нужно внимательно читать описание автомобиля перед бронированием.',
                    attrs: {style: 'margin-left:0px !important;'},
                },
            ],
        },
        {
            blockType: 'text',
            blockTitle: 'Где жить',
            content: [
                {
                    tag: 'p',
                    content: [
                        'В Калининграде есть один пятизвёздочный отель, построенный к Чемпионату мира по футболу 2018, — ',
                        {
                            tag: 'a',
                            content: {
                                tag: 'u',
                                content: 'Crystal House Suite Hotel & SPA',
                            },
                            attrs: {href: 'https://crystalhousehotel.ru/ru/'},
                        },
                        ' (стоимость ночи в люксе в несезон — от 11 700 ₽, в сезон — 18 000 ₽). В городе также представлены четырёхзвёздочные отели международных сетей: ',
                        {
                            tag: 'a',
                            content: {tag: 'u', content: 'Radisson'},
                            attrs: {
                                href: 'https://www.radissonhotels.com/ru-ru/hotels/radisson-blu-kaliningrad',
                            },
                        },
                        ' (цена номера в сутки — от 6000 ₽ в несезон, в сезон — 11 000 ₽), ',
                        {
                            tag: 'a',
                            content: {tag: 'u', content: 'Holiday Inn'},
                            attrs: {
                                href: 'https://www.ihg.com/holidayinn/hotels/ru/ru/kaliningrad/kgdka/hoteldetail',
                            },
                        },
                        ' (от 10 000 ₽ в сезон), ',
                        {
                            tag: 'a',
                            content: {tag: 'u', content: 'Mercure'},
                            attrs: {
                                href: 'https://all.accor.com/hotel/A336/index.ru.shtml',
                            },
                        },
                        ' (от 15 000 ₽ в сезон).',
                    ],
                    attrs: {style: 'margin-left:0px;'},
                },
                {
                    tag: 'p',
                    content: [
                        'В туристическом районе Рыбная деревня (самый открыточный вид Калининграда с ресторанами и магазинами янтаря) можно остановиться в гостиницах ',
                        {
                            tag: 'a',
                            content: {tag: 'u', content: '«Кайзерхоф»'},
                            attrs: {href: 'https://kaiserhof-hotel.com/'},
                        },
                        ' с довольно большим спа (от 12 350 ₽), ',
                        {
                            tag: 'a',
                            content: {tag: 'u', content: '«У медового моста»'},
                            attrs: {href: 'http://honeybridge.ru/'},
                        },
                        ' (от 7850 ₽), ',
                        {
                            tag: 'a',
                            content: {tag: 'u', content: '«Шкиперская»'},
                            attrs: {href: 'http://www.skipperhotel.ru/'},
                        },
                        ' (от 6200 ₽).',
                    ],
                    attrs: {style: 'margin-left:0px;'},
                },
                {
                    tag: 'p',
                    content: [
                        'В историческом районе Калининграда Амалиенау (с дореволюционной застройкой, уютными двориками и зелёными улицами) есть несколько симпатичных дизайнерских отелей: ',
                        {
                            tag: 'a',
                            content: {tag: 'u', content: '«Чайковский»'},
                            attrs: {
                                href: 'https://ageevgroup.ru/hotels/tchaikovsky/',
                            },
                        },
                        ' (от 7800 ₽), ',
                        {
                            tag: 'a',
                            content: {tag: 'u', content: '«Анна»'},
                            attrs: {
                                href: 'https://anna-boutique-hotel-kaliningrad.nochi.com/',
                            },
                        },
                        ' (от 22 000 ₽ в июле-августе),',
                        {
                            tag: 'a',
                            content: {tag: 'u', content: ' Villa Toscana'},
                            attrs: {href: 'http://villatoscana.ru/'},
                        },
                        ' (от 12 000 ₽). Популярен и загородный отель ',
                        {
                            tag: 'a',
                            content: {tag: 'u', content: '«Усадьба»'},
                            attrs: {
                                href: 'https://ageevgroup.ru/hotels/usadba/',
                            },
                        },
                        ' в 20 минутах езды от центра города (от 7300 ₽ за номер на двоих) — он находится в уединённом месте с красивой природой, в летний сезон там работает открытый бассейн.',
                    ],
                    attrs: {style: 'margin-left:0px;'},
                },
            ],
        },
        {
            blockType: 'text',
            blockTitle: 'Где поесть в Калининграде',
            content: [
                {
                    tag: 'h4',
                    content: 'Рестораны',
                    attrs: {style: 'margin-left:0px;'},
                },
                {
                    tag: 'p',
                    content: [
                        {tag: 'strong', content: 'Гастробар «Соль»'},
                        ' (ул. Космонавта Леонова, 55) — модный ресторан, где нужно бронировать стол даже на вечер буднего дня. Место, правда, того стоит. Здесь стильный дизайн, профессиональный персонал, богатая винная карта и, конечно, очень вкусно. В меню можно найти классические блюда, но больший упор сделан на азиатскую кухню: заказать стоит потрясающие татаки из мраморной говядины (595 ₽) и бао с мясом камчатского краба (495 ₽). Ещё одно направление ресторана — Raw&Local, то есть местные продукты, поданные в сыром виде, например тартар из оленины и севиче из лосося (по 435 ₽). Самая дорогая позиция в меню — филе миньон с трюфельным пюре (985 ₽), самая популярная — хрустящие баклажаны с томатами и молодым сыром (395 ₽). Порции не очень большие, поэтому обычно здесь берут несколько блюд на компанию и пробуют всё понемногу.',
                    ],
                    attrs: {style: 'margin-left:0px;'},
                },
            ],
        },
        {
            blockType: 'image_set',
            blockTitle: null,
            imgSet: [
                {
                    img: '//avatars.mds.yandex.net/get-marketcms/879900/img-e414b261-22ef-4e46-ac04-81913794e499.jpeg/optimize',
                    comment: 'Фото: Гастробар «Соль»',
                },
            ],
        },
        {
            blockType: 'text',
            blockTitle: null,
            content: [
                {
                    tag: 'p',
                    content: [
                        'Ресторан ',
                        {tag: 'strong', content: 'Seasons'},
                        ' (Мира, 74) — одно из самых новых модных заведений города. Концепция этого стильного камерного ресторана — авторское переосмысление традиционной русской кухни. Самое популярное и «инстаграмное» блюдо — Авокадо Royal (590 ₽ с красной икрой и 985 ₽ с чёрной). Это тартар из лосося с кремом из авокадо и икрой, который подаётся в кожуре авокадо.',
                    ],
                    attrs: {style: 'margin-left:0px;'},
                },
                {
                    tag: 'p',
                    content: [
                        {tag: 'strong', content: '«Угли»'},
                        ' (Мира, 19–21) — ресторан, целиком посвящённый мясу во всех его проявлениях: от бургеров (495 ₽ за бургер от шефа) до стейков (720 ₽ за скёрт, 2200 ₽ за рибай). Приветливый персонал подробно проконсультирует по каждому блюду. И в «Углях», и в ресторанах, упомянутых выше, рекомендуем бронировать столики сильно заранее.',
                    ],
                    attrs: {style: 'margin-left:0px;'},
                },
                {
                    tag: 'p',
                    content: [
                        {tag: 'strong', content: '«Штайндамм 99»'},
                        ' (Житомирская, 22) — один из самых уютных ресторанов города расположен неподалёку от набережной Преголи. Здесь подают как классические блюда (например, невероятно вкусный борщ с говядиной и олениной за 445 ₽), так и специалитеты местной кухни, вроде рубанины из скумбрии (295 ₽) и знаменитых кёнигсбергских клопсов — тефтелей из оленины и телятины (395 ₽). В «Мушкино» (Сергеева, 14) можно попробовать дичь из расположенных за городом угодий. Ресторан особенно славится олениной (тартар — 561 ₽, вырезка, подаваемая на лава-камне, — 950 ₽).',
                    ],
                    attrs: {style: 'margin-left:0px;'},
                },
                {
                    tag: 'p',
                    content: [
                        'В пастерию ',
                        {tag: 'strong', content: 'Bravo Italia'},
                        ' (Правая набережная, 9) стоит ехать не только за пастой собственного приготовления, но и ради возможности побывать в самом настоящем действующем порту. Ресторан расположен в 15 минутах езды от центра, неподалёку от пришвартованных в речном порту кораблей.',
                    ],
                    attrs: {style: 'margin-left:0px;'},
                },
            ],
        },
        {
            blockType: 'text',
            blockTitle: 'Музеи и театры',
            content: [
                {
                    tag: 'h4',
                    content: {tag: 'strong', content: 'Фестивали'},
                    attrs: {style: 'margin-left:0px;'},
                },
                {
                    tag: 'p',
                    content: [
                        'Одно из знаковых событий города — джазовый фестиваль ',
                        {tag: 'strong', content: '«Калининград Сити Джаз»'},
                        ', который проходит в конце июля — начале августа (в 2021 году — с 30 июля по 1 августа). А в конце августа начинается ',
                        {
                            tag: 'strong',
                            content:
                                'фестиваль российского и зарубежного короткометражного кино «Короче»',
                        },
                        ', куда приезжают кинозвёзды (в 2021 году пройдёт 20-22 августа). В ноябре — декабре в рамках ',
                        {
                            tag: 'strong',
                            content: 'Фестиваля искусств «Балтийские сезоны»',
                        },
                        ' в Калининград привозят оперные, балетные, драматические и музыкальные постановки российских и зарубежных театров.',
                    ],
                    attrs: {style: 'margin-left:0px;'},
                },
                {
                    tag: 'h4',
                    content: {tag: 'strong', content: 'Театры и кинотеатры'},
                    attrs: {style: 'margin-left:0px;'},
                },
                {
                    tag: 'p',
                    content: [
                        'Культурный вечер можно провести в ',
                        {tag: 'strong', content: 'Драматическом театре'},
                        ' (Мира, 4), в репертуаре которого не только классические постановки, но и концерты калининградских оркестров — симфонического и русских народных инструментов. А на сцене ',
                        {tag: 'strong', content: 'Музыкального театра'},
                        ' (Мира, 87) ставят оперы, оперетты и мюзиклы.',
                    ],
                    attrs: {style: 'margin-left:0px;'},
                },
            ],
        },
        {
            blockType: 'image_set',
            blockTitle: null,
            imgSet: [
                {
                    img: '//avatars.mds.yandex.net/get-marketcms/1668019/img-cbe93229-f200-4d64-a60f-3b3b5f8e465f.jpeg/optimize',
                    comment: 'Фото: Shutterstock',
                },
            ],
        },
        {
            blockType: 'text',
            blockTitle: null,
            content: [
                {
                    tag: 'h4',
                    content: 'Музеи и культурные пространства',
                    attrs: {style: 'margin-left:0px;'},
                },
                {
                    tag: 'p',
                    content: [
                        {
                            tag: 'strong',
                            content:
                                'Калининградский музей изобразительных искусств',
                        },
                        ' (Ленинский пр., 83) в здании Торговой Биржи Кёнигсберга ежегодно проводит крупные выставки русского и зарубежного искусства из частных коллекций и коллекций ведущих музеев страны (Эрмитажа, Русского музея, Третьяковки, Ярославского художественного музея). Постоянная экспозиция рассказывает о художественной жизни региона c XIX века до наших дней.',
                    ],
                    attrs: {style: 'margin-left:0px;'},
                },
                {
                    tag: 'p',
                    content: [
                        {tag: 'strong', content: 'Музей Мирового Океана'},
                        ' (наб. Петра Великого, 1) — единственный федеральный музей в регионе, в состав которого входят многочисленные объекты, посвящённые теме исследования океана. Это, помимо нескольких зданий с экспозициями, исследовательские и рыболовные суда, плавучий маяк, подводная лодка, гидросамолёт, соляной батискаф и другое.',
                    ],
                    attrs: {style: 'margin-left:0px;'},
                },
                {
                    tag: 'p',
                    content: [
                        {tag: 'strong', content: 'Музей «Фридландские ворота»'},
                        ' (Дзержинского, 30), посвящённый городской жизни. Здесь рассказывают историю города через аутентичные артефакты, связанные с работой городских кафе, магазинов, аптек, кинотеатров. Эту же тему, но несколько в ином ключе, раскрывает музей-квартира Altes Haus (Красная, 11), где воссоздан интерьер квартиры 1912 года.',
                    ],
                    attrs: {style: 'margin-left:0px;'},
                },
                {
                    tag: 'p',
                    content: [
                        {
                            tag: 'strong',
                            content: 'Культурпросветпространство «Катарсис»',
                        },
                        ' (Генерал-Лейтенанта Озерова, 18) — одновременно книжный магазин и площадка, где еженедельно проходят выставки, мастер-классы, концерты, поэтические и киновечера, презентации и даже техно-вечеринки.',
                    ],
                    attrs: {style: 'margin-left:0px;'},
                },
                {
                    tag: 'p',
                    content: [
                        {tag: 'strong', content: 'Арт-пространство «Ворота»'},
                        ' (Литовский вал, 61) — некоммерческий социальный проект Калининградского союза фотохудожников. В «Воротах» проходят выставки, творческие встречи, концерты. Вход на выставки бесплатный.',
                    ],
                    attrs: {style: 'margin-left:0px;'},
                },
            ],
        },
        {
            blockType: 'text',
            blockTitle: 'Что привезти',
            content: [
                {
                    tag: 'p',
                    content: [
                        'Помимо янтаря Калининград славится ',
                        {tag: 'strong', content: 'марципаном'},
                        ', который на протяжении многих веков производился в Кёнигсберге. Впервые лакомство в виде марципанового сердечка попало в город в 1526 году из немецкого Любека как подарок на свадьбу Герцога Альбрехта и датской принцессы Доротеи. Так сердце стало традиционной формой кёнигсбергского марципана. В XIX веке в Кёнигсберге возникла одна из самых известных марципановых мануфактур Поматти, которую возродили в наши дни. Кроме марципана Поматти, в городе можно купить и марципаны немецкого, в том числе любекского, производства.',
                    ],
                    attrs: {style: 'margin-left:0px;'},
                },
                {
                    tag: 'p',
                    content: [
                        'В калининградской области много десятилетий работает рыбокомбинат «За родину», который добывает и обрабатывает ',
                        {tag: 'strong', content: 'морепродукты'},
                        '. Продукцию комбината можно приобрести в фирменных магазинах в аэропорту Храброво и на центральном рынке Калининграда (Черняховского, 15). Самый популярный деликатес — копчёный угорь — в аэропорту стоит 3500 рублей за килограмм.',
                    ],
                    attrs: {style: 'margin-left:0px;'},
                },
            ],
        },
    ],
    docid: '{{docid}}',
    _debug: {
        page_id: 162996,
        branch_id: 60380,
        branch_revision_id: 329289,
        page_name: 'Большой гид по Калининграду и области',
        revision_id: 4144972,
    },
};
