import {useMemo} from 'react';
import {useSelector} from 'react-redux';

import {IGetContextPageArticle} from 'server/api/TemplatorApi/types/IGetContextPageResponse';

import journalRootPageSelector from 'selectors/journal/journalRootPageSelector';

const diff = (a: string, b: string): number =>
    parseInt(a, 10) - parseInt(b, 10);

export function useArticles(): IGetContextPageArticle[] {
    const {data} = useSelector(journalRootPageSelector);
    const articles = data?.articles;

    return useMemo(() => {
        if (!articles) {
            return [];
        }

        return articles.sort((a, b) => {
            const [aDate, aMonth, aYear] = a.createdDate.split('.');
            const [bDate, bMonth, bYear] = b.createdDate.split('.');

            return (
                diff(bYear, aYear) || diff(bMonth, aMonth) || diff(bDate, aDate)
            );
        });
    }, [articles]);
}
