import {useLocation} from 'react-router-dom';

import {
    CONTENT_PREVIEW_KEY,
    CONTENT_PREVIEW_VALUE,
} from 'projects/journal/constants/article';

import getQueryByLocation from 'utilities/getQueryByLocation/getQueryByLocation';

export function usePreview(): boolean {
    const location = useLocation();
    const query = getQueryByLocation(location);

    return query[CONTENT_PREVIEW_KEY] === CONTENT_PREVIEW_VALUE;
}
