import React from 'react';
import {Route, Switch} from 'react-router-dom';

import {URLs} from 'constants/urls';

import {loadable} from 'utilities/pageLoadable';

import FrameRoute from 'components/FrameRoute/FrameRoute';
import PartnersPagePreloader from 'projects/partners/pages/LinkBuilder/components/PagePreloader/PagePreloader';

import LinkBuilder from 'projects/partners/pages/LinkBuilder/LinkBuilder';
import LinkBuilderExample from 'projects/partners/pages/LinkBuilderExample/LinkBuilderExample';

const NotFoundApp = loadable(
    () => import('components/NotFound/NotFoundPage/NotFoundPage'),
);

const PartnersApp: React.FC = () => {
    return (
        <Switch>
            <FrameRoute
                path={URLs.partnersBuilder}
                component={LinkBuilder}
                skeleton={<PartnersPagePreloader />}
            />
            <Route
                path={URLs.partnerBuilderExample}
                component={LinkBuilderExample}
            />
            <Route component={NotFoundApp} />
        </Switch>
    );
};

export default PartnersApp;
