import React, {useEffect, useRef, useState} from 'react';

import {useAffiliatePartnerDataProvider} from 'projects/partners/utilities/useAffiliatePartnerDataProvider';

import {dataFetchingError} from 'i18n/partnerLinkBuilder';

import Flex from 'components/Flex/Flex';
import Text from 'components/Text/Text';
import LinkBuilderForm from 'projects/partners/pages/LinkBuilder/components/LinkBuilderForm/LinkBuilderForm';
import PartnersPagePreloader from 'projects/partners/pages/LinkBuilder/components/PagePreloader/PagePreloader';

import cx from './LinkBuilder.scss';

const DATA_FETCHING_TIMEOUT = 5000;

const LinkBuilder: React.FC = () => {
    const [errorTimeout, setErrorTimeout] = useState();
    const data = useAffiliatePartnerDataProvider();
    const timeoutRef = useRef<number>();

    useEffect(() => {
        timeoutRef.current = window.setTimeout(
            setErrorTimeout,
            DATA_FETCHING_TIMEOUT,
            true,
        );

        return (): void => {
            clearTimeout(timeoutRef.current);
        };
    }, []);

    useEffect(() => {
        if (data?.platforms.length) {
            clearTimeout(timeoutRef.current);
        }
    }, [data]);

    if (errorTimeout) {
        return (
            <Flex
                className={cx('root')}
                alignItems={data?.platforms.length ? 'start' : 'center'}
                justifyContent="center"
            >
                <Text className={cx('error')}>{dataFetchingError()}</Text>
            </Flex>
        );
    }

    if (!data?.platforms.length) {
        return <PartnersPagePreloader />;
    }

    return (
        <Flex className={cx('root')} alignItems="start" justifyContent="center">
            <LinkBuilderForm platforms={data.platforms} />
        </Flex>
    );
};

export default LinkBuilder;
