import {FunctionComponent, ReactNode} from 'react';
import {noop} from 'lodash';

import {IAffiliatePlatform} from 'projects/partners/types/IAffiliatePlatform';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';

import * as i18nBuilder from 'i18n/partnerLinkBuilder';

import Box from 'components/Box/Box';
import Flex from 'components/Flex/Flex';
import Form from 'components/Form/Form';
import Heading from 'components/Heading/Heading';
import VidInput from 'projects/partners/pages/LinkBuilder/components/VidInput/VidInput';
import ClidSelect from 'projects/partners/pages/LinkBuilder/components/ClidSelect/ClidSelect';
import PartnerLink from 'projects/partners/pages/LinkBuilder/components/PartnerLink/PartnerLink';
import OriginalLink from 'projects/partners/pages/LinkBuilder/components/OriginalLink/OriginalLink';
import PlatformSelect from 'projects/partners/pages/LinkBuilder/components/PlatformSelect/PlatformSelect';

import cx from './LinkBuilderForm.scss';

interface ILinkBuilderFormProps {
    platforms: IAffiliatePlatform[];
}

const LinkBuilderForm: FunctionComponent<ILinkBuilderFormProps> = ({
    platforms,
}) => {
    const deviceType = useDeviceType();

    return (
        <Box
            className={cx('root', deviceMods('root', deviceType))}
            x="6"
            y="6"
            between="3"
        >
            <Box below="5">
                <Heading level={1}>{i18nBuilder.header()}</Heading>
            </Box>

            <Form onSubmit={noop}>
                {({handleSubmit}): ReactNode => (
                    <form onSubmit={handleSubmit}>
                        <Box between="3">
                            <PlatformSelect
                                className={cx('platform')}
                                platforms={platforms}
                            />

                            <Flex
                                between="3"
                                inline={!deviceType.isMobile}
                                flexDirection={
                                    deviceType.isMobile ? 'column' : 'row'
                                }
                                nowrap
                            >
                                <ClidSelect
                                    className={cx('clid')}
                                    platforms={platforms}
                                />

                                <VidInput className={cx('vid')} />
                            </Flex>

                            <OriginalLink className={cx('originLink')} />

                            <PartnerLink />
                        </Box>
                    </form>
                )}
            </Form>
        </Box>
    );
};

export default LinkBuilderForm;
