import React, {ReactNode, useCallback} from 'react';

import {IWithClassName} from 'types/withClassName';
import {ELinkBuilderFormField} from 'projects/partners/pages/LinkBuilder/components/LinkBuilderForm/types/ELinkBuilderFormField';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {isValidPartnerLink} from 'projects/partners/utilities/urls/validate';

import * as i18nBuilder from 'i18n/partnerLinkBuilder';

import TextArea from 'components/TextArea/TextArea';
import FormField from 'components/FormField/FormField';

const OriginalLink: React.FC<IWithClassName> = props => {
    const deviceType = useDeviceType();
    const validate = useCallback((value?: string) => {
        if (value && !isValidPartnerLink(value)) {
            return i18nBuilder.originLinkError();
        }
    }, []);

    return (
        <FormField
            validate={validate}
            control={(
                {input: {fieldProps, ...input}},
                {error, controlRef},
            ): ReactNode => (
                <TextArea
                    {...input}
                    {...fieldProps}
                    innerRef={controlRef}
                    state={error ? 'error' : undefined}
                    withAutoResize
                    hasClear
                    size="m"
                    placeholder={i18nBuilder.originLinkPlaceholder()}
                />
            )}
            fieldProps={props}
            deviceType={deviceType}
            name={ELinkBuilderFormField.ORIGINAL_LINK}
        />
    );
};

export default OriginalLink;
