import React from 'react';

import Flex from 'components/Flex/Flex';
import Text from 'components/Text/Text';
import TriggerDetailsButton from 'components/TriggerDetailsButton/TriggerDetailsButton';

import cx from './PartnerFieldLabel.scss';

interface IPartnerFieldLabelProps {
    label: string;
    target: string;
    hint?: string;
    useBottomSheet?: boolean;
}

const PartnerFieldLabel: React.FC<IPartnerFieldLabelProps> = props => (
    <Flex alignItems="center" inline between="1">
        <label className={cx('label')} htmlFor={props.target}>
            <Text color="secondary" size="m">
                {props.label}
            </Text>
        </label>

        {props.hint && (
            <TriggerDetailsButton
                className={cx('hint')}
                forceBottomSheet={props.useBottomSheet}
            >
                <div className={cx('hintContent')}>{props.hint}</div>
            </TriggerDetailsButton>
        )}
    </Flex>
);

export default PartnerFieldLabel;
