import React, {ReactNode, useCallback} from 'react';

import {IWithClassName} from 'types/withClassName';
import {ELinkBuilderFormField} from 'projects/partners/pages/LinkBuilder/components/LinkBuilderForm/types/ELinkBuilderFormField';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import * as i18nBuilder from 'i18n/partnerLinkBuilder';

import Input from 'components/Input/Input';
import FormField from 'components/FormField/FormField';
import PartnerFieldLabel from 'projects/partners/pages/LinkBuilder/components/PartnerFieldLabel/PartnerFieldLabel';

interface IVidInputProps extends IWithClassName {}

const VidInput: React.FC<IVidInputProps> = ({className}) => {
    const deviceType = useDeviceType();
    const validate = useCallback((value?: string) => {
        if (!value) {
            return;
        }

        const numberValue = parseInt(value, 10);

        if (
            isNaN(numberValue) ||
            numberValue < 0 ||
            numberValue > 999 ||
            numberValue.toString(10) !== value
        ) {
            return i18nBuilder.vidError();
        }
    }, []);

    return (
        <FormField
            className={className}
            validate={validate}
            title={
                <PartnerFieldLabel
                    label="VID"
                    target={ELinkBuilderFormField.AFFILIATE_VID}
                    hint={i18nBuilder.vidHint()}
                    useBottomSheet={false}
                />
            }
            control={({input}, {error, controlRef}): ReactNode => (
                <Input
                    {...input}
                    id={input.name}
                    innerRef={controlRef}
                    state={error ? 'error' : undefined}
                    size="l"
                    type="text"
                />
            )}
            deviceType={deviceType}
            name={ELinkBuilderFormField.AFFILIATE_VID}
        />
    );
};

export default VidInput;
