import React from 'react';
import {useSelector} from 'react-redux';

import {partnersBuilder} from 'constants/urls/partners';

import {IAffiliatePartnerData} from 'projects/partners/types/IAffiliatePartnerData';

import nonceSelector from 'selectors/common/nonceSelector';

import Flex from 'components/Flex/Flex';

import cx from './LinkBuilderExample.scss';

const getClids = (length: number): string[] =>
    Array.from({length}, () => Math.round(Math.random() * 1000).toString());

const MOCK_DATA: IAffiliatePartnerData = {
    platforms: [
        {
            name: 'vk',
            clids: ['single'],
        },
        {
            name: 'facebook',
            clids: getClids(3),
        },
        {
            name: 'travel.me',
            clids: getClids(12),
        },
        {
            name: 'vandrouki',
            clids: getClids(20),
        },
        {
            name: 'tutu',
            clids: getClids(8),
        },
    ],
};

const LinkBuilderExample: React.FC = () => {
    const nonce = useSelector(nonceSelector);

    return (
        <Flex x="2" y="2" className={cx('root')}>
            <div
                className={cx('wrapper')}
                dangerouslySetInnerHTML={{
                    __html: `
                    <script type="text/javascript" nonce="${nonce}">
                        (function(w) {
                            function handleMessage(e) {
                                if (e.data.type === 'YA_TRAVEL_AFFILIATE_INIT') {
                                    e.source.postMessage({
                                        type: 'YA_TRAVEL_AFFILIATE_DATA',
                                        payload: ${JSON.stringify(MOCK_DATA)},
                                    }, e.origin);

                                    w.removeEventListener('message', handleMessage, false);
                                }
                            }

                            w.addEventListener('message', handleMessage, false);
                        })(window);
                    </script>

                    <iframe
                        src="${partnersBuilder}"
                        frameborder="0"
                        style="height: 100%; width: 100%; max-width: 500px; border: 1px solid #eee;"
                        allow="clipboard-write"
                    />
            `,
                }}
            />
        </Flex>
    );
};

export default LinkBuilderExample;
